% Code for: Capital Reallocation and Aggregate Productivity
% R. Cooper & I. Schott
% Code version: September 2022


Table3_data_A   = readmatrix(sprintf('%s/Table3_data_A.csv',PARMS.tabfolder));
Table3_data_F   = readmatrix(sprintf('%s/Table3_data_F.csv',PARMS.tabfolder));

fprintf('TABLE 3: Model moments\n\n')
fprintf(2,'TFP model\n\n')
% Targeted
fprintf('Correlation R Atilde\t\t%1.3f\n',round(round(Table3_data_A(1),4),3));
fprintf('Sigma R/K\t\t\t%1.3f\n\n',round(round(Table3_data_A(2),4),3));
% Untargeted
fprintf('Sigma PI\t\t\t%1.3f\n',round(Table3_data_A(3),2));
fprintf('Correlation SIG_ARPK Atilde\t%1.3f\n',round(round(Table3_data_A(4),4),3));
fprintf('Correlation PI Atilde\t\t%1.3f\n',round(round(Table3_data_A(5),4),3));
fprintf('AR(1) Atilde\t\t\t%1.3f\n',round(round(Table3_data_A(6),4),3));
fprintf('Sigma Atilde\t\t\t%1.3f\n',round(round(Table3_data_A(7),4),3));

fprintf(2,'\n\nF model\n\n')
% Targeted
fprintf('Correlation R Atilde\t\t%1.3f\n',round(round(Table3_data_F(1),4),3));
fprintf('Sigma R/K\t\t\t%1.3f\n\n',round(round(Table3_data_F(2),4),3));
% Untargeted
fprintf('Sigma PI\t\t\t%1.3f\n',round(Table3_data_F(3),2));
fprintf('Correlation SIG_ARPK Atilde\t%1.3f\n',round(round(Table3_data_F(4),4),3));
fprintf('Correlation PI Atilde\t\t%1.3f\n',round(round(Table3_data_F(5),4),3));
fprintf('AR(1) Atilde\t\t\t%1.3f\n',round(round(Table3_data_F(6),4),3));
fprintf('Sigma Atilde\t\t\t%1.3f\n',round(round(Table3_data_F(7),4),3));

clear Table3*